// ------------------------------------
//       STDIO.C CONSOLE INTERFACE 
//            Version 2.03
// by:Harry Konstas & Philippe Guillot
//            March 4, 2002 
// ------------------------------------ 
 
#include "stdio.h" 
#include "VFSmgr.h" 
 
typedef void *va_list;
#define va_start(ap, parmN) ((void)((ap) = (va_list)((char *)(&parmN)+((sizeof(parmN)+1) & 0xfffe))))


// ------------------------------------  
//             prototypes 
// ------------------------------------ 

// Stdio Library systraps 
Err StdioOpen(UInt) SYS_TRAP(sysLibTrapOpen); 
Err StdioClose(UInt,UIntPtr) SYS_TRAP(sysLibTrapClose); 
Err StdioSleep(UInt) SYS_TRAP(sysLibTrapSleep); 
Err StdioWake(UInt) SYS_TRAP(sysLibTrapWake); 
Err InitStdout(UInt,FontID*,int,int,int,int) SYS_TRAP(sysLibTrapCustom); 
Err ClearStdout(UInt) SYS_TRAP(sysLibTrapCustom+1); 
Err PrintStdout(UInt,char*) SYS_TRAP(sysLibTrapCustom+2); 
Err GetStdin(UInt,char*) SYS_TRAP(sysLibTrapCustom+3); 
Err CloseStdout(UInt,DOCFILE*) SYS_TRAP(sysLibTrapCustom+4); 
Err PutStdout(UInt,char) SYS_TRAP(sysLibTrapCustom+5); 
Err GetStdKey(UInt,int*) SYS_TRAP(sysLibTrapCustom+6); 
Err RevStr(UInt,char*) SYS_TRAP(sysLibTrapCustom+7); 
Err LongToA(UInt,long,char*,UInt16) SYS_TRAP(sysLibTrapCustom+8); 
Err NewDoc(UInt16,DOCFILE**,CharPtr) SYS_TRAP(sysLibTrapCustom+9); 
Err OpenDoc(UInt16,DOCFILE**,CharPtr) SYS_TRAP(sysLibTrapCustom+10); 
Err CloseDoc(UInt16,DOCFILE*) SYS_TRAP(sysLibTrapCustom+11); 
Err WriteDoc(UInt16,DOCFILE*,CharPtr t) SYS_TRAP(sysLibTrapCustom+12); 
Err ReadDocLine(UInt16,DOCFILE*,int,char*) SYS_TRAP(sysLibTrapCustom+13); 
Err GetFontHandles(UInt16,Handle*,Handle*) SYS_TRAP(sysLibTrapCustom+14);
Err OpenStdin(UInt16,DOCFILE**) SYS_TRAP(sysLibTrapCustom+15);
Err CloseStdin(UInt16,DOCFILE*) SYS_TRAP(sysLibTrapCustom+16);
Err GetCharIn(UInt16,DOCFILE*,int*c) SYS_TRAP(sysLibTrapCustom+17);
Err DeleteDB(UInt16,char*) SYS_TRAP(sysLibTrapCustom+18);
Err NewDB(UInt16,DmOpenRef**,char*,ULong,ULong) SYS_TRAP(sysLibTrapCustom+19);
Err OpenDB(UInt16,DmOpenRef**,char*) SYS_TRAP(sysLibTrapCustom+20);
Err fwritedoc(UInt16,void*,int,int,DOCFILE*,int*) SYS_TRAP(sysLibTrapCustom+21);
Err freadoc(UInt16,void*,int,int,DOCFILE*,int*) SYS_TRAP(sysLibTrapCustom+22);
Err StdioGotoXY(UInt16,int,int) SYS_TRAP(sysLibTrapCustom+23);
Err WriteDocChar(UInt16 refnum,DOCFILE *pDoc, unsigned char c) SYS_TRAP(sysLibTrapCustom+24);
Err OpenStdout(UInt16,DOCFILE**) SYS_TRAP(sysLibTrapCustom+25);
Err FixToA(UInt16,double,char*,Int32) SYS_TRAP(sysLibTrapCustom+26);
Err FPutS(UInt16,char*,DOCFILE*) SYS_TRAP(sysLibTrapCustom+27);
Err FGetS(UInt16,char*,int,DOCFILE*) SYS_TRAP(sysLibTrapCustom+28);
Err StrToL(UInt16,Int32*,char*,char**,int) SYS_TRAP(sysLibTrapCustom+29);
Err StrToD(UInt16,double*,char*,char**) SYS_TRAP(sysLibTrapCustom+30);

// library
Err SysLibOpen(UInt16, UInt16) SYS_TRAP(sysLibTrapOpen); 
Err SysLibClose(UInt16, UInt16*) SYS_TRAP(sysLibTrapClose);  
 
// Event 
Boolean EvtSysEventAvail(Boolean ignorePenUps) SYS_TRAP(sysTrapEvtSysEventAvail); 
void EvtEnableGraffiti(Boolean enable) SYS_TRAP(sysTrapEvtEnableGraffiti); 
Err EvtResetAutoOffTimer(void) SYS_TRAP(sysTrapEvtResetAutoOffTimer); 
 
// System 
Err FntDefineFont(FontID fontID, FontPtr fontP) SYS_TRAP(sysTrapFntDefineFont); 
void SysAppLauncherDialog() SYS_TRAP(sysTrapSysAppLauncherDialog); 
Word SysTicksPerSecond(void) SYS_TRAP(sysTrapSysTicksPerSecond); 
Err SysUIAppSwitch (UInt cardNo, LocalID dbID, Word cmd, Ptr cmdPBP)  
    SYS_TRAP(sysTrapSysUIAppSwitch); 

 // Mem/Database 
UInt16 MemHeapID(UInt16,UInt16) SYS_TRAP(sysTrapMemHeapID); 
Err MemHeapFreeBytes(UInt16,UInt32*,UInt32*) SYS_TRAP(sysTrapMemHeapFreeBytes); 
Boolean SysGetStackInfo(MemPtr*,MemPtr*) SYS_TRAP(sysTrapSysGetStackInfo); 
Err DmDeleteRecord(DmOpenRef dbP, UInt index) SYS_TRAP(sysTrapDmDeleteRecord); 
Err MemPtrResize(VoidPtr p,ULong newSize) SYS_TRAP(sysTrapMemPtrResize); 
Err DmWriteCheck(VoidPtr p,ULong offset, ULong bytes) SYS_TRAP(sysTrapDmWriteCheck); 
Err DmOpenDatabaseInfo(DmOpenRef dbP, LocalID* dbIDP, UIntPtr openCountP, UIntPtr modeP, UIntPtr cardNoP, Boolean *resDBP) 
      SYS_TRAP(sysTrapDmOpenDatabaseInfo); 
 
 
// ------------------------------------  
//              globals 
// ------------------------------------ 
 
char curpath[120]; 
 
FileRef fileRef; 
FileInfoType fileInfo; 
UInt16 volRefNum=0, cfcard=0;  
 
// global variable to memorise the stack state 
UInt32 memA6; 
 
// pseudo stdout/stderr 
FILE *stdout, *stderr;
// pseudo stdin
FILE *stdin;
 
// stdio library use counter 
Int16 StdioLibRef=-1; 
 
// last error 
int errno; 
 
Handle hTinyFont; 
Handle hStdFont; 
 
int NumArgs; 
char*CmdArgs[16]; 
 
 
// ------------------------------------  
//           Exit function 
// ------------------------------------ 
 
static UInt32 getA6(void) 
{ 
  return memA6; 
} 
 
static void setA6(UInt32 x) 
{ 
  memA6=x; 
} 
 
asm void Tag(void) 
{ 
  link a6,#0 
  move.l a6,-(a7)  ; push a6 
  jsr setA6_00(pc) ; no need of add #4,a7 
  unlk a6 
  rts 
} 
 
asm void exit(int code) 
{ 
  jsr getA6_00(pc) ; get value in d0 
  movea.l d0,a6    ; restore a6 
  move 4(a7),d0    ; return value 
  unlk a6          ; restore stack 
  rts 
} 
 
 
// ------------------------------------  
//         IO stream functions 
// ------------------------------------ 
 
void fclose(FILE*pf) 
{ 
  errno=CloseDoc(StdioLibRef,pf); 
} 
 
 
FILE *fopen(char *fname,char *mode) 
{ 

  FILE *pF;

  if(strstr(mode,"w"))
    errno=NewDoc(StdioLibRef,&pF,fname); 
  else 
    errno=OpenDoc(StdioLibRef,&pF,fname); 
 
  return pF; 
 
} 

int feof(FILE *pf)
{
  if(pf->nRecs>=0)
    return pf->iRec>=pf->nRecs;
  else return 0;

}  
 
char putch(char c) 
{ 
  errno=PutStdout(StdioLibRef,c); 
  return c; 
} 
 
void FVPrintF(FILE*pF,char*fs,void*parm) 
{ 
 
  char buf[300]; 
 
  StrVPrintF(buf,fs,parm); 
 
  // process stderr/stdout
  switch (pF->nRecs)
  {
    case -2:  
     errno=PrintStdout(StdioLibRef,buf); 
     return;
    case -1: 
     errno=WriteDoc(StdioLibRef,pF,buf); 
     return;
    default:
     errno=EIO;
  }
} 
 
void fprintf(FILE *pF,char *fs) 
{ 
  va_list parm; 
 
  va_start(parm,fs); 
  FVPrintF(pF,fs,parm); 
} 
 
// output on stdout 
void printf(char*fs) 
{ 
  va_list parm; 
 
  va_start(parm,fs); 
  FVPrintF(stdout,fs,parm); 
} 
 
void printf(char *fs, ...); 
void fprintf(FILE *pF,char *fs, ...); 
 
int fgetc(FILE*pf)
{
 int c;
 errno=GetCharIn(StdioLibRef,pf,&c);
 return c;
}

int getchar(void)
{
 return fgetc(stdin);
}
 
char *fgets(char *s, int n, FILE *pF)  
{ 
  errno=FGetS(StdioLibRef,s,n,pF);
  if(errno)
  {
   *s=0;
   return NULL;
  }
  return s;
}
 
char* gets(char*s) 
{
 return fgets(s,512,stdin);
} 

 
int fputs(char *s, FILE *pF) 
{
 errno=FPutS(StdioLibRef,s,pF);
 if(errno) return EOF; else return 0;
}

int puts(char *buf) 
{ 
  return fputs(buf,stdout);
} 
 
// input character from console 
int getch() 
{ 
  int c; 
  errno=GetStdKey(StdioLibRef,&c); 
  return c; 
} 

int fread(void *pData,unsigned int size,unsigned int blocks,FILE *pF) 
{
  int r;
  freadoc(StdioLibRef,pData,size,blocks,pF,&r);
  return r;
}

int fwrite(void *pData,unsigned int size,unsigned int blocks,FILE *pF) 
{
  int r;
  fwritedoc(StdioLibRef,pData,size,blocks,pF,&r);
  return r;
}

// todo: fseek
// SEEK_SET 0,CUR 1, END 2 return 1 on error
int fseek(FILE *pF, long offset, int w)
{
  return 0;
}
 
int fputc(int c, FILE *pF)
{
  return WriteDocChar(StdioLibRef,pF, c);
}


// ------------------------------------  
//             Utilities 
// ------------------------------------ 
 
// returns VFS reference if exp.card is available
UInt16 GetVfsRef(void)
{

  int err;
  UInt16 volRefNum=0,slotRefNum=0; 
  UInt32 volIterator,slotIterator;
  UInt32 vfsMgrVersion;

  slotIterator=expIteratorStart;

  err=FtrGet(sysFileCVFSMgr,0,&vfsMgrVersion);
  if(err) return 0;

  while (slotIterator != expIteratorStop) { 
    err = ExpSlotEnumerate(&slotRefNum, &slotIterator);  
    if(err!=errNone) return 0;
    else break;
  }

  err=ExpCardPresent(slotRefNum);
  if(err!=errNone) return 0;

  volIterator = vfsIteratorStart; 
 
  while (volIterator != vfsIteratorStop) { 
    err = VFSVolumeEnumerate(&volRefNum, &volIterator);  
    if (err == errNone) return volRefNum; 
  }
  return 0;

}

void textmode(int x) 
{ 
  FontID fnt; 
  switch(x) 
  { 
 
   case BW80: 
     fnt=128; 
     break; 
 
   case BW40: 
     fnt=129; 
     break; 
 
  } 
 
  errno=InitStdout(StdioLibRef,&fnt,0,0,160,160); 
 
} 

void srand(UInt32 seed) 
{ 
  SysRandom(seed); 
} 
 
int rand(void) 
{ 
  return SysRandom(0); 
} 
 
void beep(void) 
{ 
  SndPlaySystemSound(1); 
} 
 
 
int UserAbort(void) 
{ 
  int x,y,t; 
 
  EvtGetPen(&x,&y,&t); 
  if((t)&&y>160&&x<30) return 1; 
  
  return 0; 
} 
 
void clrscr(void) 
{ 
  ClearStdout(StdioLibRef); 
} 
 
void gotoxy(int x, int y) 
{ 
 StdioGotoXY(StdioLibRef,x,y);
} 
 
char *strupr(char *s) 
{ 
  int i=0; 
  unsigned char c; 
 
  while(c=s[i])  
  { 
    if( ( (c>='a')&&(c<='z') ) || 
        ( (c>=224)&&(c<=254) ) )  
      s[i]=c-32; 
    i++; 
  } 
  return s; 
} 
 
char *getdate(char *buffer) 
{ 
 
  DateTimeType D; 
 
  TimSecondsToDateTime(TimGetSeconds(),&D); 
  StrPrintF(buffer,"%02d/%02d/%02d", 
          D.month, D.day, D.year); 
 
  return buffer; 
 
} 
 
 
float atof(char *s) 
{ 
 
  FlpCompDouble cf; 
  float f; 
 
  cf.fd=FlpAToF(s); 
  f=cf.d; 
 
  return f; 
 
} 
 

char* ftoa(double f,char*buf,int prec)
{

  errno=FixToA(StdioLibRef,f,buf,prec);
  return buf;

}

 
float abs(float x) 
{ 
  if(x<0) x=x*-1; 
  return x; 
} 
 
char *itoa(int v,char *buffer,int base) 
{ 
  LongToA(StdioLibRef,v,buffer,base); 
  return buffer; 
} 
 
int atoi(char *buffer) 
{ 
  int v; 
 
  v=(int)StrAToI(buffer); 
  return v; 
} 
 
char *ltoa(long v,char *buffer,int base) 
{ 
  LongToA(StdioLibRef,v,buffer,base); 
  return buffer; 
} 

long strtol(char*s,char**e,int base)
{
 long l;
 errno=StrToL(StdioLibRef,&l,s,e,base);
 return l;
}

double strtod(char*s,char**e)
{
 double d;
 errno=StrToD(StdioLibRef,&d,s,e);
 return d;
}

int isalpha(int c)
{
  if(c>='a'&&c<='z') return 1;
  if(c>='A'&&c<='A') return 1;
  return 0;
}

int toupper(int c)
{
  if(c>='a'&&c<='z') return c-32;
  return c;
}

int isdigit(int c)
{
  if(c>='0'&&c<='9') return 1;
  return 0;
}

int tolower(int c)
{
  if(c>='A'&&c<='Z') return c+32;
  return c;
}


// ------------------------------------ 
//            Memory info 
// ------------------------------------ 
 
UInt32 coreleft(void) 
{ 
  LocalID id; 
  UInt32 free,max; 
 
  id=MemHeapID(0,0); 
  MemHeapFreeBytes(id,&free,&max); 
  return free; 
} 
 
UInt32 stackavail(void) 
{ 
  MemPtr start,end; 
  SysGetStackInfo(&start,&end); 
  return (UInt32)end-(UInt32)start; 
} 
 
// ------------------------------------  
//         File/dir utilities 
// ------------------------------------ 
 
int chdir(char *path) 
{ 
 
  StrCopy(curpath,path); 
  return 0; 
 
} 
 
char *getcwd(char *buf, int buflen) 
{ 
  StrCopy(buf,curpath); 
  return buf; 
} 
 
char *AddPath(char *path, char *fname) 
{ 
 
  path[0]=0; 
 
  if(fname[0]!='\\') { 
    StrCopy(path,curpath); 
    StrCat(path,"\\"); 
  } 
 
  StrCat(path,fname); 
  return path; 
 
} 
 
long open(char *fname, int flags, int mode) 
{ 
  long h; 
  UInt16 err; 
  char buf[120]; 
 
  AddPath(buf,fname); 
 
  err=VFSFileOpen(volRefNum,buf,flags,&h); 
  if(err==errNone) return h; 
 
  return -1L; 
} 
 
int close(long h) 
{ 
  
  int r; 
  
  r=VFSFileClose(h); 
  if(r!=errNone) return -1; 
  return 0; 
 
} 
 
long read(long h,void *buf,long size) 
{ 
 
  int e; 
  long r; 
 
  e=VFSFileRead(h,size,buf,&r); 
  if(e!=errNone) return -1L; 
 
  return r; 
 
} 
 
long write(long h,void *buf,long size) 
{ 
 
  int e; 
  long w; 
 
  e=VFSFileWrite(h,size,buf,&w); 
  if(e!=errNone) return -1L; 
 
  return w; 
 
} 
 
long lseek(long h,long offset,int origin) 
{ 
 
  int r; 
  long fpos; 
 
  r=VFSFileSeek(h,origin,offset); 
  if(r!=errNone) return -1L; 
  r=VFSFileTell(h,&fpos); 
  if(r!=errNone) return -1L; 
  return fpos; 
 
} 
 
int remove(char *fname) 
{ 
  int r; 
  char buf[120]; 
 
  AddPath(buf,fname); 
  r=VFSFileDelete(volRefNum,buf); 
  if(r!=errNone) return -1; 
  return 0; 
 
} 
 
int rename(char *oldname,char *newname) 
{ 
  int r; 
  char buf[120]; 
 
  AddPath(buf,oldname); 
  r=VFSFileRename(volRefNum,buf,newname); 
  if(r!=errNone) return -1; 
  return 0; 
 
} 
 
long getdfree(void) 
{ 
  long used, total; 
 
  VFSVolumeSize(volRefNum,&used,&total); 
  return total-used; 
}

int mkdir(char *dirname) 
{ 
  int r; 
  char buf[120]; 
 
  AddPath(buf,dirname); 
  r=VFSDirCreate(volRefNum,buf); 
  if(r!=errNone) return -1; 
  return 0; 
 
} 
 
int rmdir(char *dirname) 
{ 
  int r; 
  char buf[120]; 
 
  AddPath(buf,dirname); 
  r=VFSFileDelete(volRefNum,buf);  
  if(r!=errNone) return -1; 
  return 0; 
 
} 
 
// ------------------------------------  
//          Other utilities 
// ------------------------------------ 
 
 
// to do : correct error mamagement 
// in case font can't be defined 
 
int GetFonts(void) 
{ 
 
  int err; 
  FontPtr pData; 

  err=GetFontHandles(StdioLibRef,&hTinyFont,&hStdFont);
  if(hTinyFont) 
  { 
    pData=MemHandleLock(hTinyFont); 
    err=FntDefineFont(128,pData); 
    if (err) return err; 
  } 
  else return 1; 
 
  if(hStdFont) 
  { 
    pData=MemHandleLock(hStdFont); 
    err=FntDefineFont(129,pData); 
  } 
  else return 1; 
  return err; 
 
} 

int AppSwitch(char *fname) 
{ 
 
  LocalID dbID; 
 
  dbID=DmFindDatabase(0,fname); 
  if(dbID==NULL) return 0; 
 
  SysUIAppSwitch(0,dbID,sysAppLaunchCmdNormalLaunch,NULL); 
  return 1; 
 
} 
 
// ------------------------------------  
//      Launch DOS app with params 
// ------------------------------------ 
 
 
int Main(void) 
{ 
  return main(NumArgs,CmdArgs); 
} 
 
void LaunchDOS(void) 
{ 
  
  int i,size,n,r; 
  int flag=0; 
  char *data; 
 
  VoidHand h; 
  DmOpenRef db; 
 
  NumArgs=0; 
 
  strcpy(curpath,"\\"); 

  if(OpenDB(StdioLibRef,&db,"VFSDOSdata")==0) { 
    n=DmNumRecords(db); 
    if(n>15) n=15; 
 
    for(i=0;i<n;i++) { 
      h=DmQueryRecord(db,i); 
      if(!h) break; 
      size=MemHandleSize(h); 
      if(!size) break; 
      data=MemHandleLock(h); 
 
      if(i==0) strcpy(curpath,data); 
      else{ 
        CmdArgs[NumArgs]=malloc(40); 
        strcpy(CmdArgs[NumArgs],data); 
        NumArgs++; flag=1; 
      } 
 
      MemHandleUnlock(h); 
    } 
  } 
 
  if(db) DmCloseDatabase(db); 
  if(!flag) NumArgs=-1; 
  
  Tag(); 
  r=Main(); 
 
  if(r!=-999&&r!=-998) { 
    printf("\n\nPress any key to return to DOS..."); 
    getch(); 
  } 
 
  if(flag) 
    for(i=0;i<NumArgs;i++)  
      free(CmdArgs[i]); 
 
} 
 
// ------------------------------------  
//              M A I N 
// ------------------------------------ 
 
 
DWord PilotMain( Word cmd, Ptr cmdPBP, Word launchFlags)  
{ 
 
  int err; 
  FontID fID=128; 
  FormPtr frmP; 
  UInt usecount; 
 
  switch (cmd) 
  { 
    case sysAppLaunchCmdNormalLaunch: 
 
      frmP = FrmInitForm(1000); 
      FrmSetActiveForm(frmP); 
 
      // init StdioLib
      err=SysLibFind("StdioLib",&StdioLibRef);
      if(err!=0)
      { // library not loaded already
        err=SysLibLoad('libr','pDOS',&StdioLibRef); 
        if (err==0)
          err=SysLibOpen(StdioLibRef,1);
      }
      if(err) return 0;
      err=GetFonts();
      if (err) return 0;

      InitStdout(StdioLibRef,&fID,0,0,160,160);

      // check for vfs card & launch DOS 
      volRefNum=GetVfsRef(); 
      if(volRefNum) cfcard=1; 

      // set pseudo stderr/stdout

      if(OpenStdout(StdioLibRef,&stdout)) return 0;
      if(OpenStdout(StdioLibRef,&stderr)) return 0;
      if(OpenStdin(StdioLibRef,&stdin)) return 0;

      LaunchDOS(); 
 
      CloseStdin(StdioLibRef,stdin);
      CloseStdout(StdioLibRef,stdout);
      CloseStdout(StdioLibRef,stderr);

      // Close StdioLib 
      if(StdioLibRef!=-1) 
      { 
        err=SysLibClose(StdioLibRef,&usecount); 
        if (usecount==0) 
        { 
          SysLibRemove(StdioLibRef); 
        } 
      } 
 
      FntSetFont(fID); // restore font 
      MemHandleUnlock(hTinyFont);
      MemHandleUnlock(hStdFont);
      break; 
 
    default: 
      break; 
  }
  return 0;
} 

